#!/usr/bin/env python
import os
import sys

dataset = sys.argv[1]


libraries = []
directory = "/osc-fs_home/mdehoon/Data/CASPARs/%s/Mapping/" % dataset
filenames = os.listdir(directory)
for filename in filenames:
    library, extension = filename.split(".")
    assert extension == "bam"
    libraries.append(library)

libraries.sort()

output = open('script.sh', 'w')
for library in libraries:
    script_name = "script_%s_%s.sh" % (dataset, library)
    handle = open(script_name, 'w')
    handle.write("""\
#!/bin/bash
#SBATCH -e ./script_%s_%s.stderr
#SBATCH -o ./script_%s_%s.stdout
#SBATCH --mem=4G
python create_ctss_file.py %s %s
""" % (dataset, library, dataset, library, dataset, library))
    handle.close()
    output.write('sbatch %s\n' % script_name)
output.close()
print("Scripts generated; run script.sh to schedule them on Grid Engine")
